# Generated Python Strategy for: PlayerB (meta)
# Run Index: 8
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run8_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    code = opponent_program_code.lower()
    
    # Check for always_cooperate or always_defect
    always_cooperate = ("always_cooperate" in code or 
                        "return 'c'" in code or 
                        "return c" in code)
    always_defect = ("always_defect" in code or 
                     "return 'd'" in code or 
                     "return d" in code)
    
    if always_cooperate:
        return "C"
    if always_defect:
        return "D"
    
    # Check for tit-for-tat patterns
    tit_for_tat = ("tit_for_tat" in code or 
                   "opp_history[-1]" in code or 
                   "return opp_history[-1]" in code)
    
    if tit_for_tat:
        return opp_history[-1]
    
    # Check for random behavior
    is_random = ("random.choice" in code or 
                 "random.randint" in code or 
                 "random.random" in code)
    
    if is_random:
        return "D"  # Defect against random strategies
    
    # Check for code length heuristic
    lines = opponent_program_code.splitlines()
    if len(lines) < 5:
        return "C"  # Cooperate with simple strategies
    
    # Fallback to cautious Tit-for-Tat with forgiveness
    if opp_history[-1] == "C":
        return "C"
    else:
        # Forgive occasional defections
        if len(opp_history) >= 3 and opp_history[-2:] == ["D", "D"]:
            return "D"
        elif len(opp_history) >= 5 and sum(1 for m in opp_history[-5:] if m == "D") >= 4:
            return "D"
        else:
            return "C"